/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class FIPAService {
    private static int cnt = 0;

    private static synchronized int getNextInt() {
        int ret = cnt;
        cnt = cnt < 9999 ? (cnt = cnt + 1) : 0;
        return ret;
    }

    static ACLMessage createRequestMessage(Agent sender, AID receiver) {
        ACLMessage request = new ACLMessage(16);
        request.setSender(sender.getAID());
        request.addReceiver(receiver);
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl0");
        request.setOntology("FIPA-Agent-Management");
        int n = FIPAService.getNextInt();
        request.setReplyWith("rw-" + sender.getName() + System.currentTimeMillis() + '-' + n);
        request.setConversationId("conv-" + sender.getName() + System.currentTimeMillis() + '-' + n);
        return request;
    }

    public static ACLMessage doFipaRequestClient(Agent a, ACLMessage request) throws FIPAException {
        return FIPAService.doFipaRequestClient(a, request, 0L);
    }

    public static ACLMessage doFipaRequestClient(Agent a, ACLMessage request, long timeout) throws FIPAException {
        if (request.getReplyWith() == null) {
            request.setReplyWith("rw-" + a.getLocalName() + System.currentTimeMillis() + '-' + FIPAService.getNextInt());
        }
        long sendTime = System.currentTimeMillis();
        a.send(request);
        MessageTemplate mt = MessageTemplate.MatchInReplyTo(request.getReplyWith());
        ACLMessage reply = a.blockingReceive(mt, timeout);
        if (reply != null) {
            if (reply.getPerformative() == 7) {
                return reply;
            }
            if (reply.getPerformative() == 1) {
                long agreeTime;
                if (timeout > 0L && (timeout -= (agreeTime = System.currentTimeMillis()) - sendTime) <= 0L) {
                    return null;
                }
                reply = a.blockingReceive(mt, timeout);
            }
            if (reply != null) {
                if (reply.getPerformative() == 7) {
                    return reply;
                }
                throw new FIPAException(reply);
            }
        }
        return null;
    }
}

